r = 1

gotflashlight = 1
bigfoot = 1

SCREEN 12
COLOR 7, 0
CLS

DIM SHARED DOOM AS DOUBLE
Minutes = 10
Seconds = 0
GameTime = Minutes * 60 + Seconds

DIM directions(1 TO 9) AS STRING
directions(1) = "SOUTH"
directions(2) = "NORTH, SOUTH, OR EAST"
directions(3) = "WEST"
directions(4) = "NORTH OR WEST"
directions(5) = "EAST OR SOUTH"
directions(6) = "NORTH OR EAST"
directions(7) = "WEST OR EAST"
directions(8) = "NORTH OR WEST"
directions(9) = "SOUTH"

PRINT ""
PRINT ""
PRINT "It was a nice and sunny day. Upon the shores of which you had wished to"
PRINT "venture forth into the icy water of the Atlantic. Off in the distance, you"
PRINT "see a small island. You recall the times you and your friends thought it"
PRINT "was haunted by those slaughtered by the hands of a beast. Now, you will"
PRINT "find just what lurks in the shadows of the island. You arrive and find that"
PRINT "you are truly alone. The vessel you have taken drifts away back to the"
PRINT "mainland. As if someone or something no longer wanted to inhabit said"
PRINT "cursed land."
PRINT ""

DO: LOOP UNTIL INKEY$ <> ""
DOOM = TIMER(0.001) + GameTime 'change this to to desied time for the game to run

DO
    CLS
    PRINT
    PRINT
    PRINT "                                                                          "
    PRINT "                                                                          "
    PRINT "                                                                          "
    PRINT "                                 The Island                 "
    PRINT "                                                                          "
    PRINT "                                 Written by                               "
    PRINT "                                                                          "
    PRINT "                                D.B. Taylor"
    PRINT ""
    PRINT "                             Copyright (c) 2015"
    PRINT ""
    PRINT SPACE$(38);
    IF INSTR(directions(r), "NORTH") THEN PRINT "N" ELSE PRINT
    PRINT "*---------------------------------* ";
    IF INSTR(directions(r), "WEST") THEN PRINT "W"; ELSE PRINT " ";
    PRINT " + ";
    IF INSTR(directions(r), "EAST") THEN PRINT "E"; ELSE PRINT " ";
    PRINT " *------------------------------------*"
    PRINT SPACE$(38);
    IF INSTR(directions(r), "SOUTH") THEN PRINT "S" ELSE PRINT
    PRINT
    PRINT "If you are stuck just type HELP."
    PRINT
    GOSUB ROOM
    GOSUB parser
LOOP

ROOM:
IF r = 1 THEN: GOSUB r1
IF r = 2 THEN: GOSUB r2
IF r = 3 THEN: GOSUB r3
IF r = 4 THEN: GOSUB r4
IF r = 5 THEN: GOSUB r5
IF r = 6 THEN: GOSUB r6
IF r = 7 THEN: GOSUB r7
IF r = 8 THEN: GOSUB r8
IF r = 9 THEN: GOSUB r9

RETURN

parser:
PRINT "> ";
cmd$ = GrabInput
cmd$ = LTRIM$(RTRIM$(UCASE$(cmd$)))
IF cmd$ = "END" OR cmd$ = "QUIT" OR cmd$ = "EXIT" OR cmd$ = "Q" THEN
    END
END IF
IF cmd$ = "HELP" OR cmd$ = "H" OR cmd$ = "?" THEN
    CLS
    PRINT "HERE ARE SOME BASIC COMMANDS THAT CAN BE USED IN THE GAME..."
    PRINT
    PRINT "NORTH, EAST ,SOUTH, AND WEST - MOVE TO AN AVAILABLE LOCATION"
    PRINT "EXAMINE (OBJECT)             - EXAMINE AN OBJECT"
    PRINT "USE (OBJECT)                 - USE AN OBJECT"
    PRINT "TAKE (OBJECT)                - TAKE OR MOVE AN OBJECT"
    PRINT "INVENTORY                    - VIEW YOUR INVENTORY"
    PRINT "DRINK                        - DRINK BEER"
    PRINT "UNLOCK                       - UNLOCK DOOR"
    PRINT "HELP                         - VIEW THIS SCREEN"
    PRINT "END                          - END GAME"
    PRINT
    PRINT "PRESS ANY KEY...": SLEEP
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
END IF
IF cmd$ = "INVENTORY" OR cmd$ = "INV" OR cmd$ = "ITEMS" OR cmd$ = "I" THEN
    CLS
    PRINT "INVENTORY..."
    PRINT
    IF gotflashlight = 1 THEN: PRINT "An old red flashlight. Bought years ago."
    PRINT
    PRINT "PRESS ANY KEY..."
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
END IF
IF cmd$ = "GO NORTH" OR cmd$ = "NORTH" OR cmd$ = "N" THEN
    IF r = 8 THEN: r = 9: GOTO moved
    IF r = 6 THEN: r = 5: GOTO moved
    IF r = 4 THEN: r = 2: GOTO moved
    IF r = 2 THEN: r = 1: GOTO moved
END IF
IF cmd$ = "GO EAST" OR cmd$ = "EAST" OR cmd$ = "E" THEN
    IF r = 2 THEN: r = 3: GOTO moved
    IF r = 5 THEN: r = 4: GOTO moved
    IF r = 6 THEN: r = 7: GOTO moved
    IF r = 7 THEN: r = 8: GOTO moved
END IF
IF cmd$ = "GO SOUTH" OR cmd$ = "SOUTH" OR cmd$ = "S" THEN
    IF r = 1 THEN: r = 2: GOTO moved
    IF r = 2 THEN: r = 4: GOTO moved
    IF r = 5 THEN: r = 6: GOTO moved
    IF r = 9 THEN: r = 8: GOTO moved
END IF
IF cmd$ = "GO WEST" OR cmd$ = "WEST" OR cmd$ = "W" THEN
    IF r = 3 THEN: r = 2: GOTO moved
    IF r = 4 THEN: r = 5: GOTO moved
    IF r = 8 THEN: r = 7: GOTO moved
    IF r = 7 THEN: r = 6: GOTO moved
END IF

IF (cmd$ = "USE FLASHLIGHT") THEN
    CLS
    PRINT "It's on!"
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
END IF
IF (cmd$ = "EXAMINE MONSTER") AND r = 8 THEN
    CLS
    PRINT "It stands at about five feet tall. It's skin is wrinkled and green."
    PRINT "A strange gree fungus, is slowly consuming it's flesh. It's eye's are"
    PRINT "a bright yellow. As if they were like suns in a far away galaxy."
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
END IF
IF (cmd$ = "EXAMINE FLASHLIGHT") AND gotflashlight = 1 THEN
    CLS
    PRINT "An old flashlight crafted a few decades ago. Has some weight to it"
    PRINT "though."
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
END IF
IF (cmd$ = "BEAT MONSTER TO DEATH") AND r = 8 THEN
    CLS
    GOTO win1:
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
END IF
IF (cmd$ = "RETURN TO BOAT") AND r = 9 THEN
    CLS
    PRINT "You are sitting in the boat."
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
END IF
IF (cmd$ = "ROW HOME") AND r = 9 THEN
    CLS
    GOTO win:
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
END IF
IF (cmd$ = "GO HOME") THEN
    CLS
    GOTO lose:
    DO: LOOP UNTIL INKEY$ = ""
    DO: LOOP UNTIL INKEY$ <> ""
END IF

moved:
RETURN

r1:
PRINT "The sky is growing black. As the sun is blanketed over by a dark"
PRINT "force. You feel sick to your stomach. Knowing that your time here"
PRINT "will be longer then wished."
RETURN

r2:
PRINT "You are standing on the rocky surface of the island."
RETURN

r3:
PRINT "A faint stench of rotten fish fills the air. A chill runs down"
PRINT "your spine."
RETURN

r4:
PRINT "A few old tree's scatter the landscape. A growl sounding like"
PRINT "a bear comes from the darkness."
RETURN

r5:
PRINT "You are standing now on the firm soul that was put here by someone"
PRINT "hoping to grow a garden of sorts. The tree's around you start moving"
PRINT "amd swaying. Like they are alive."
RETURN

r6:
PRINT "You've heard of stories about this place. You've heard of a creature"
PRINT "that use to lure fools to their fate. Looks like I am one of those fools."
RETURN

r7:
PRINT "You've made your way towards a small gathering of tree's. You hear"
PRINT "someone or something breathing a few feet away from you."
RETURN

r8:
PRINT "In a small clearing, you see the monster. It hasn't spotted you yet"
PRINT "as it's drawing in the soil. How strange, yet simple minded being."
RETURN

r9:
PRINT "You are standing at the shore of the island. You see that strangly"
PRINT "enough, your boat has returned?"
RETURN

win1:
COLOR 2, 0
CLS
PRINT "You tightly grip the flashlight and without making a sound"
PRINT "and swolling all your fear. You beat the monster to death."
PRINT "Before it could react, the beast has been defeated. You calm"
PRINT "yourself down and make way to the shore to where your boat"
PRINT "rests. Leaving the blood soaked flashlight behind and you"
PRINT "return home. Not mentioning what had happened that fateful"
PRINT "night."
PRINT
DO: LOOP UNTIL INKEY$ <> ""
END

win:
COLOR 2, 0
CLS
PRINT "You push the boat out into the lake. As you begin rowing back"
PRINT "you notice the glimmering eye's of the monster that calls the"
PRINT "island home. God only knows what it would have done to you."
PRINT
DO: LOOP UNTIL INKEY$ <> ""
END

lose:
COLOR 2, 0
CLS
PRINT "You run from the dark confines of the island and suddenly, you"
PRINT "notice the beast not far behind. You reach the shoreline and only"
PRINT "to find that the boat is gone. Just then, the monster drags you"
PRINT "back into the darkness. To where it devours your flesh and soul."
PRINT
DO: LOOP UNTIL INKEY$ <> ""
END

FUNCTION GrabInput$
x = POS(0)
y = CSRLIN
maxwidth = _WIDTH - x
PCOPY 0, 1 'make a backup copy of the screen

DO
    k = _KEYHIT
    i$ = INKEY$
LOOP UNTIL k = 0 AND INKEY$ = "" 'clear the keyboard buffer

DO
    _LIMIT 30
    PCOPY 1, 0
    LOCATE y, x: PRINT Userinput$

    k = _KEYHIT
    SELECT CASE k
        CASE 8
            Userinput$ = LEFT$(Userinput$, LEN(Userinput$) - 1)
        CASE 65 TO 90, 97 TO 122, 32
            Userinput$ = UCASE$(Userinput$ + CHR$(k))
    END SELECT

    timerleft## = (DOOM - TIMER(0.001))
    minutes = timerleft## \ 60
    seconds = timerleft## - minutes * 60
    LOCATE 2, 32: PRINT USING " ###:##.###"; minutes, seconds
    IF timerleft## <= 0 THEN GOTO doomed
    _DISPLAY

LOOP UNTIL k = 13
GrabInput$ = Userinput$
_AUTODISPLAY
EXIT FUNCTION

doomed:
CLS
PRINT "The sun begin's to rise as you are rescued by a boat passing by. There"
PRINT "was nothing there. No monster? No animal? Nobody? Just your mind."
_DISPLAY
END
END SUB

